<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns="http://www.insophy.cz/inplan/plan/5.x"
	xmlns:oldNs="http://www.insophy.cz/inplan/plan/4.x"
	>
  
  <!-- update the namespace -->
  <xsl:template match="/oldNs:plan">
    <xsl:element 
      name="plan" 
      namespace="http://www.insophy.cz/inplan/plan/5.x" >
      <xsl:attribute name="schemaVersion">5.x</xsl:attribute>
	  <xsl:choose>
        <xsl:when test="@revision">
	      <xsl:attribute name="revision">
		    <xsl:value-of select="@revision" />
	      </xsl:attribute>
        </xsl:when>
	  </xsl:choose>
      <xsl:apply-templates />
    </xsl:element>    
  </xsl:template>

  <!-- remove stores -->
  <xsl:template match="//oldNs:source-schedule">
  </xsl:template>

  <xsl:template match="//oldNs:destination-schedules">
  </xsl:template>

  <xsl:template match="//oldNs:gor/@dest-store">
  </xsl:template>

  <xsl:template match="//@store">
  </xsl:template>

  <!-- modify GORs with respect to gprs -->
  <xsl:template match="//oldNs:gor[./oldNs:gpr]">
      <xsl:element name="{name()}">
          <xsl:if test="oldNs:gpr/@actiongram">
              <xsl:attribute name="actiongram">
                  <xsl:value-of select="oldNs:gpr/@actiongram" />
              </xsl:attribute>
          </xsl:if>
          <xsl:if test="oldNs:gpr/@actiongram-locked">
              <xsl:attribute name="actiongram-locked">
                  <xsl:value-of select="oldNs:gpr/@actiongram-locked" />
              </xsl:attribute>
          </xsl:if>
          <xsl:apply-templates select="@*"/>
          <xsl:apply-templates select="oldNs:properties"/>
          <xsl:apply-templates select="oldNs:gpr[1]/*"/>
      </xsl:element>
  </xsl:template>

  <!-- remove the GPRs  -->
  <xsl:template match="//oldNs:gpr">
  </xsl:template>

  <!-- remove the cluster-chunks  -->
  <xsl:template match="//oldNs:gor[@cluster-chunks]">
  </xsl:template>
  
  <!-- remove the gor groups  -->
  <xsl:template match="//oldNs:gor/@groups">
  </xsl:template>
  
  <!-- remove the products and their gors -->
  <xsl:template match="//oldNs:gor[./oldNs:product]">
  </xsl:template>



  <!-- copy the rest -->
  <xsl:template match="@*|text()">
    <xsl:copy>
      <xsl:apply-templates select="@*|text()"/>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="*">
    <xsl:element name="{name()}">
      <xsl:apply-templates select="*|@*|text()"/>
    </xsl:element>
  </xsl:template>
  
</xsl:stylesheet>
